
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Jul 22 10:17:10 2007
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief description of this module 
   *
   *  \version KMNG_ATP_TST_ManageOp.c#1:csrc:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include <stdio.h>
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_Mem.h"
#include "CRYS.h"
#include "CRYS_KMNG.h"
#include "CRYS_AES.h"
#include "CRYS_DES.h"
#include "CRYS_error.h"
#include "CRYS_HASH.h"
#include "CRYS_HMAC.h"
#include "CRYS_RSA_Types.h"
#include "KMNG_Defs.h"
#include "KMNG_SEP_ATP_Defines.h"
#include "SEP_ATP_UTIL_funcs.h"
#include "KMNG_SEP_ATP_KeysOp.h"

//#include "LLF_KMNG_DEF.h"
#include "KMNG_Defs.h"
#include "LLF_KMNG.h"
#include "KMNG_SEP_ATP_KeysOp.h"



/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/

//DxUint32_t TST_KeyOperations_Buf[KMNG_TST_MAX_SIZE_KEY_RING_BUF];
//KMNG_AES_WrappedKey_t   TST_AESWrappedKey;
//KMNG_DES_WrappedKey_t   TST_DESWrappedKey;
//KMNG_HMAC_WrappedKey_t  TST_HMACWrappedKey;
//KMNG_RSA_WrappedKey_t   TST_RSAWrappedKey;
//KMNG_DH_WrappedKey_t	  TST_DHWrappedKey;

//extern DxUint32_t TST_KeyRing_Buf[KMNG_TST_MAX_SIZE_KEY_RING_BUF];

//extern const DxUint32_t TST_NumOf_SymKeysOpTests;
//extern const DxUint32_t TST_NumOf_RSAKeysOpTests;
//extern const DxUint32_t TST_NumOf_DHKeysTests;

//extern TST_Ext_KeysSym_TestDataStruct SEP_AES_KeysOpSym_TestData[];
//extern TST_Ext_KeysSym_TestDataStruct SEP_DES_KeysOpSym_TestData[];
//extern TST_Ext_KeysSym_TestDataStruct SEP_HMAC_KeysOpSym_TestData[];
//extern TST_KeysRSA_TestDataStruct SEP_KeysOpRSA_TestData[];
//extern TST_KeysDHData_TestDataStruct SEP_KeysDHData_TestData[];

TST_Ext_KeysSym_TestDataStruct *SEP_KeysOpSym_TestData;
//extern TST_KeysSym_TestDataStruct TST_KeysOpSym_TestData[];
//extern TST_KeysRSA_TestDataStruct TST_KeysOpRSA_TestData[];
//extern TST_KeysRSAHASHData_TestDataStruct TST_KeysOpRSAHASHData_TestData[];
//extern TST_KeysDHData_TestDataStruct TST_KeysDHData_TestData[];

//extern CRYS_DHUserPubKey_t TST_DHUserPubKey;
//extern CRYS_DHPrimeData_t  TST_DHPrimeData;
//TST_KeyDHServerData_Struct TST_KeyDHServerData;
//
//DxError_t SEP_KMNG_ATP_Ext_ImportExportSymKeys( void );

/************* Private function prototype ***********************/
/************************ Public Functions ******************************/



DxError_t SEP_KMNG_ATP_Ext_ImportExportSymKeys( void ) 
{

	/********* TST Variables Definitions ************/
	DxUint32_t				TST_index = 0; 
	DxError_t				TST_error = 0;
	DxError_t				TST_Status = DX_SUCCESS, TST_TestStatus = DX_SUCCESS;        
	DxUint8_t               TST_KeyRingPwd[TST_KMNG_PWD_MAX_LEN] = {0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9};
	DxUint32_t              TST_KeyRingPwdLen = 10;
	DxChar					TST_MasterTestName[TST_FUNC_STRING_LEN] = "SEP_KMNG_ATP_Ext_ImportExportSymKeys";     

	/* paramaters for create key */
	KMNG_KeyDataParameter_t   masterKeyDataParam;
	

	/* configuration parameters */
	KMNG_KeyConfiguration_t   masterKeyConfiguration;

	/* paramaters for create key */
	KMNG_KeyDataParameter_t   userKeyDataParam;

	/* configuration parameters */
	KMNG_KeyConfiguration_t   userKeyConfiguration;

	/* configuration parameters */
	KMNG_KeyConfiguration_t   exportedUserKeyConfiguration;

	// for master key
	DxUint8_t					encryptedKeyBuffer[KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES];
	DxUint8_t					savedEncryptedKeyBuffer[KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES];
	DxUint32_t					savedEncryptedKeyDataLength;
	DxUint8_t					userEncryptedKeyBuffer[KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES];
	
	/* set master key paramaters (should be AES key) */
	masterKeyDataParam.keyPassword_ptr = TST_KeyRingPwd;
	masterKeyDataParam.keyPasswordLen = TST_KeyRingPwdLen;
	masterKeyDataParam.encryptedKeyData_ptr = (DxUint8_t*)encryptedKeyBuffer;
	masterKeyDataParam.encryptedKeyDataLength = KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES;

	/* set master key configuration */
	masterKeyConfiguration.type = KMNG_KeyTypeAES; 
	masterKeyConfiguration.keySizeBytes = KMNG_AES_MAX_KEY_SIZE_IN_BYTES; /*256 Bits Key*/
	masterKeyConfiguration.usage = KMNG_KEY_USAGE_STORAGE;
	masterKeyConfiguration.restriction = KMNG_KEY_RESTRICTION_NON_EXPORTABLE;  /* instead PROTECTED.  May be other?? */

	/* create key */
	TST_error = LLF_KMNG_CreateKeyRingKey(&masterKeyDataParam , &masterKeyConfiguration);

	TST_TestStatus = ATP_TST_CheckErrorReturn(TST_error,
		"LLF_KMNG_CreateKeyRingKey",
		SEP_KeysOpSym_TestData[TST_index].TST_Name,
		TST_MasterTestName);

	if (TST_TestStatus != DX_SUCCESS) 
		goto End;

	/* save master key, because it will be unwrapped in each KMNG operation */
	DX_VOS_FastMemCpy(savedEncryptedKeyBuffer, masterKeyDataParam.encryptedKeyData_ptr, KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES);
	savedEncryptedKeyDataLength = masterKeyDataParam.encryptedKeyDataLength;

	/* set user key paramaters */
	userKeyDataParam.keyPassword_ptr = SEP_KeysOpSym_TestData[TST_index].TST_KeyPwd;
	userKeyDataParam.keyPasswordLen = SEP_KeysOpSym_TestData[TST_index].TST_KeyPwdLen;
	/* userKeyDataParam.keyId - will return from LLF layer */
	userKeyDataParam.encryptedKeyData_ptr = (DxUint8_t*)userEncryptedKeyBuffer;
	userKeyDataParam.encryptedKeyDataLength = KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES;

	/* set key configuration */
	userKeyConfiguration.type = SEP_KeysOpSym_TestData[TST_index].TST_KeyType;
	userKeyConfiguration.usage = SEP_KeysOpSym_TestData[TST_index].TST_KeyUsage;
	userKeyConfiguration.keySizeBytes = SEP_KeysOpSym_TestData[TST_index].TST_KeySize;  
	userKeyConfiguration.restriction = SEP_KeysOpSym_TestData[TST_index].TST_KeyRestriction;

	/* if UserSpecificKeyData is not NULL, then copy user specific data into configuration structure,
	else set it to 0  */
	userKeyConfiguration.UserSpecificKeyData[0] = SEP_KeysOpSym_TestData[TST_index].TST_UserData[0];
	userKeyConfiguration.UserSpecificKeyData[1] = SEP_KeysOpSym_TestData[TST_index].TST_UserData[1];  	



	/* create key */
	TST_error = LLF_KMNG_ImportSymUserKey(&masterKeyDataParam,
		&userKeyConfiguration ,
		&userKeyDataParam ,
		SEP_KeysOpSym_TestData[TST_index].TST_key);


	TST_TestStatus = ATP_TST_CheckErrorReturn(TST_error,
		"LLF_KMNG_ImportSymUserKey",
		SEP_KeysOpSym_TestData[TST_index].TST_Name,
		TST_MasterTestName);

	if (TST_TestStatus != DX_SUCCESS) 
		goto End;

	
	// restore the encrypted key:
	DX_VOS_FastMemCpy(masterKeyDataParam.encryptedKeyData_ptr, savedEncryptedKeyBuffer, KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES);
	masterKeyDataParam.encryptedKeyDataLength = savedEncryptedKeyDataLength;

	/* export key */
	TST_error = LLF_KMNG_ExportSymUserKey(&masterKeyDataParam, 
		&exportedUserKeyConfiguration , 
		&userKeyDataParam , 
		SEP_KeysOpSym_TestData[TST_index].TST_Exportedkey,
		&SEP_KeysOpSym_TestData[TST_index].TST_KeySize);

	TST_TestStatus = ATP_TST_CheckErrorReturn(TST_error,
		"LLF_KMNG_ExportSymUserKey",
		SEP_KeysOpSym_TestData[TST_index].TST_Name,
		TST_MasterTestName);

	if (TST_TestStatus != DX_SUCCESS) 
		goto End;

	/********** Verify exported data **********/
	/* Verify key type */
	if (SEP_KeysOpSym_TestData[TST_index].TST_KeyType != exportedUserKeyConfiguration.type)
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Exported key is different than expected \n"));
		return (DxError_t)KMNG_TEST_FAIL;  
	}
	/* Verify key size */
	if (SEP_KeysOpSym_TestData[TST_index].TST_KeySize != exportedUserKeyConfiguration.keySizeBytes)
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Exported key is different than expected \n"));
		return (DxError_t)KMNG_TEST_FAIL;  
	}
	/* Verify key usage */
	if (SEP_KeysOpSym_TestData[TST_index].TST_KeyUsage != exportedUserKeyConfiguration.usage)
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Exported key is different than expected \n"));
		return (DxError_t)KMNG_TEST_FAIL;  
	}
	/* Verify key restriction */
	if (SEP_KeysOpSym_TestData[TST_index].TST_KeyRestriction != exportedUserKeyConfiguration.restriction)
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Exported key is different than expected \n"));
		return (DxError_t)KMNG_TEST_FAIL;  
	}

	/* Verify key data*/
	TST_Status = (DxUint32_t)DX_VOS_MemCmp((DxUint8_t*)SEP_KeysOpSym_TestData[TST_index].TST_Exportedkey,(DxUint8_t*)SEP_KeysOpSym_TestData[TST_index].TST_key, 
		SEP_KeysOpSym_TestData[TST_index].TST_KeySize*sizeof(DxUint8_t));

	/* comparison should fail in case of created key */
	if (TST_Status != DX_SUCCESS)
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Exported key is different than expected \n"));
		return (DxError_t)KMNG_TEST_FAIL;    

	}

End:
	return TST_Status; 

}

